/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.common.ServerActions;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundEquipBackpackPacket {
    private final boolean equip;

    public ServerboundEquipBackpackPacket(boolean equip) {
        this.equip = equip;
    }

    public static ServerboundEquipBackpackPacket decode(FriendlyByteBuf buffer) {
        boolean equip = buffer.readBoolean();
        return new ServerboundEquipBackpackPacket(equip);
    }

    public static void encode(ServerboundEquipBackpackPacket message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.equip);
    }

    public static void handle(ServerboundEquipBackpackPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayer != null) {
                if (message.equip) {
                    ServerActions.equipBackpack((Player)serverPlayer);
                } else {
                    ServerActions.unequipBackpack((Player)serverPlayer);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

